#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################


use strict;

sub	substapts {
	my ($html, $path, $avs, $sec, $pnum) = @_;
	study $html;
	$html =~ s/%([a-zA-Z0-9]+)([-_](\w+))?(\s+(.*?))?%/&aptssymbol(lc($1), lc($3), $5, $sec, $pnum, $avs, $path)/gse;
	return $html;
}

sub	aptssymbol {
	my ($symbol, $type, $params, $sec, $pnum, $avs, $filename) = @_;
	my (%p, $out);
	my $ac = dosql(qq[select name from ap_avs where id = "$avs"]);
	$cf{avsname} = ($ac->fetchrow_array)[0] if $ac->rows;
	my $basepath = "$cf{basepath}/$cf{dir}/$cf{avsdir}" .
		($sec eq "cont" ? "/$cf{memarea}" : "");
	my $baseurl = "$cf{baseurl}/$cf{dir}/$cf{avsdir}" .
		($sec eq "cont" ? "/$cf{memarea}" : "");

	$params = "type=$type $params" if ($type);
	foreach (split(/\s+/, $params)) {
		/^(\w+)\s*=\s*(["']?)([^"']*?)\2$/;
		my ($tag, $value) = (lc($1), $3);
		perr(uc($tag)." field specified twice ($p{$tag}, $value)", $filename)
			if ($p{$tag});
		$p{$tag} = $value;
	}

	for ($symbol) {
		if (/^(.+)image$/)
			{ $symbol = "image"; 	$p{type} = $1; }
		elsif (/^logo$/)
			{ $symbol = "image"; 	$p{type} = "logo"; }
		elsif (/^textlink$/)
		 	{ $symbol = "link"; 	$p{type} = "text"; }
		elsif (/^banner$/)
			{ $symbol = "link"; 	$p{type} = "banner"; }
		elsif (/^pagelink$/)
			{ $symbol = "link"; 	$p{realm} = "page"; }
		elsif (/^sponlink$/)
			{ $symbol = "link"; 	$p{realm} = "sponsor"; }
		elsif (/^intlink$/ || /^sitelink$/)
			{ $symbol = "link"; 	$p{realm} = "site"; }
		elsif (/^nextpage$/)
			{
				$symbol = "link";
				$p{realm} = "page";
				$p{type} ||= "text";
				$p{page} ||= $pnum + 1;
				$p{text} ||= "Next Page";
			}
		elsif (/^keyword$/)
			{ $symbol = "keywords"; $p{num} ||= 1; }
	}

	my $cat = $p{cat} || $p{niche} || $cf{cat} || $cats[rand(@cats)];
	my %textdefaults = (
		# text symbol factory settings

		# symbol		table		rand/uniq as default 
		header		=> [	"headers", 	0	],
		descr		=> [	"descr",	0	],
		paragraph	=> [	"paragraphs",	1	]
	);

	if ($symbol eq "image" && !$cf{image}) {
		my ($imagepath);
		if ($p{type} eq "logo" && !true($p{rand})) {
			$imagepath = $cf{logo}
				or perr("No default logo available", $filename);
		} else {
			$p{type} ||= randline("imagetypes", "", "name");
			$imagepath = randimg($cat, $p{type});
		}
		(my $imgname = $imagepath) =~ s/^.*\/([^\/]+)$/$1/;
		cpimage($imagepath, "$basepath/images", $imgname);
		my $href = "http://$baseurl/images/$imgname";
		if (true($p{href})) {
			$out = $href;
		} else {
			$out = qq[<img src="$href"].
				(defined $p{border} ? qq[ border="$p{border}"] : "").
				qq[>];
		}
	}

	elsif ($symbol eq "sitename" || $symbol eq "sitetitle") {
		if (!true($p{rand})) {
			$out = $cf{sitename};
		} else {
			$out = randline("sitenames", qq[where cat="$cat" or cat=""], "name")
				or perr("Could not find suitable sitename for category $cat, please add", $filename);
		}
	}

	elsif ($symbol eq "header" || $symbol eq "descr" || $symbol eq "paragraph") {
		my ($table, $defrand) = ($textdefaults{$symbol}[0], $textdefaults{$symbol}[1]);
		if ((!$defrand && true($p{rand})) || ($defrand && !false($p{rand}))) {
			my $catchk = ($symbol eq "header" ?
				qq[where (cat = "$cat" or cat = "")] :
				qq[where (cats regexp "$cat" or cats = "")]);
			my $query = $catchk;
			$query .= uniq($table, "text")
				if ((!$defrand && true($p{unique})) || ($defrand && !false($p{unique})));
			$out = randline($table, $query, "text")
				or err("Not enough valid ${symbol}s found, niche $cat; please add more");
			if ($cf{"rem${symbol}s"} && !$cf{test}) {
				dosql(qq[delete from ap_$table $catchk and text="$out"]);
			}			                        
		} else {
			$out = $cf{$symbol};
		}
		push (@{$used{$table}}, quotemeta($out))
			if (!grep { /^\Q$out\E$/ } @{$used{$table}});
		$out =~ s/\n/<br>\n/gm;
	}

	elsif ($symbol eq "keywords") {
		if (!true($p{rand}) && $cf{keywords}) {
			$out = ($p{num} ?
				join(" ", @{$cf{keywords}}[0..($p{num} - 1)]) :
				join(" ", @{$cf{keywords}}));
		} else {
			my $n = 0;
			my @keywords;
			while ($n < ($p{num} || $cf{numkeywords})) {
				my $query = qq[where (cats regexp "$cat" or cats = "") ].
					join("", map { qq[ and word != "$_" ] } @keywords);
				my $keyword = randline("keywords", $query, "word")
					or perr("Not enough keywords found in keyword database for niche $cat", $filename);
				push (@keywords, $keyword);
				$n++;
			}
			$out = join(" ", @keywords);
		}
	}

	elsif ($symbol eq "link") {
		$p{type} = "href" if (true($p{href}));
		# check this
		if ($p{type} ne "banner" && $p{type} ne "text" && $p{type} ne "href" && $p{realm} !~ /^s/) {
			$p{type} = ("banner", "btext", "text")[int(rand(2))];
		}

		if ($p{realm} =~ /^page/) {
			my $page = $p{page} || $p{pnum} || ($pnum + 1);
			$page = $pnum + 1 if $page eq "next";
			perr("No such page number: $page (sec $sec, pages $#{$cf{$sec}})", $filename)
				if !defined($page) || !${$cf{$sec}}[$page];
			my $imagetype = ${$cf{$sec}}[$page];
			my $prev_matches = scalar(grep { /^$imagetype$/ } @{$cf{$sec}}[1..$page]);
			my $href = "http://$baseurl/${$cf{$sec}}[$page]".
				($prev_matches < 2 ? "" : $prev_matches) .
				".$cf{htmlext}";
			if ($p{type} eq "href") {
				$out = $href;
			} else {
				my $text = $p{text} || "Page $page";
				$out = qq[<a href="$href">$text</a>];
			}
		}
		elsif ($p{realm} =~ /^(site|int)/) {
			my $query = qq[where cat = "$cat"];
			my $href = randline("sites", $query);
			my $url = "http://$$href{domain}/$$href{dir}/";
			if ($p{type} eq "href") {
				$out = $url
			}
			else {
				my $text = randline("textlinks", qq[where (cat = "$cat" or cat = "") and sponsor=""], "text")
					or perr("No suitable text links found, niche $cat", $filename);
				$out = qq[<a href="$url">$text</a>];
			}
		}
		else {
			my $sponsor;
			if (!($sponsor = $p{sponsor})) {
				if (!false($p{rand})) {
					my $query = qq[where (cats regexp "$cat" or cats = "")];
					if (true($p{unique})) {
						foreach (@{$used{sponsors}}) {
							$query .= qq[ and id != "$_"];
						}
					}
					$sponsor = randline("sponsors", $query, "id")
						or perr("No suitable sponsors found for niche $cat", $filename);
					push (@{$used{sponsors}}, $sponsor)
						if (!grep { /^$sponsor$/ } @{$used{sponsors}});
				} else {
					$sponsor = $cf{sponsor};
				}
			}
		
			my $ac = dosql(qq[select linkcode from ap_sponsors where id="$sponsor"]);
			perr("No relevant sponsors found", $filename) if (!$ac->rows);
			my $link = ($ac->fetchrow_array)[0];

			if ($p{type} eq "href") {
				$out = $link;
			}
			elsif ($p{type} eq "btext") {
				my $banner = randfile("$cf{imagepath}/banners/$sponsor")
					or perr("No banners found for sponsor $sponsor, please upload to $cf{imagepath}/banners/$sponsor", $filename);
				mkdir_r("$basepath/banners");
				cpimage("$cf{imagepath}/banners/$sponsor/$banner", "$basepath/banners", $banner);
				my $text = randline("textlinks", qq[where sponsor="$sponsor" or (sponsor="" and (cat = "$cat" or cat=""))], "text");
				$banner = qq[<img src="http://$baseurl/banners/$banner">];
				$out = qq[<a href="$link">].
					(rand() < 0.5 ? "$banner<br>$text" : "$text<br>$banner").
					qq[</a>\n];
			}
			elsif ($p{type} eq "banner") {
				my $banner = randfile("$cf{imagepath}/banners/$sponsor")
					or perr("No banners found for sponsor $sponsor, please upload to $cf{imagepath}/banners/$sponsor", $filename);
				mkdir_r("$basepath/banners");
				cpimage("$cf{imagepath}/banners/$sponsor/$banner", "$basepath/banners", $banner);
				my $href = "http://$baseurl/banners/$banner";
				if (true($p{href})) {
					$out = $href;
				} else {
					$out = qq[<a href="$link"><img src="$href"] .
						(defined $p{border} ? qq[ border="$p{border}"] : "") .
						qq[></a>];
				} 
			}
			elsif ($p{type} eq "text") {
				my $text = randline("textlinks", qq[where sponsor="$sponsor" or (sponsor="" and (cat = "$cat" or cat=""))], "text");
				if (!false($p{link})) {
					$out = qq[<a href="$link">$text</a>];
				} else {
					$out = $text;
				}
			}
		}
	}
	elsif ($symbol eq "search") {
		$cf{catselect} = qq[\t<option value="">Any\n];
		map { $cf{catselect} .= qq[\t<option value=$_>$_\n] } @cats;
		open (F, "< $cf{datapath}/intpages/searchbox.tmpl")
			or err("Could not open $cf{datapath}/intpages/searchbox.tmpl");
		s/%(\w+)%/$cf{$1}/gi, $out .= $_ while <F>;
		close F;
	}
	elsif ($symbol eq "photoset" || $symbol eq "set" || $symbol eq "imageset") {
		my ($setdir, $setname);
		if ($p{name}) {
			$setname = $p{name};
			err("No such photoset in category $cat: $p{name}") if !-d "$cf{imagepath}/$cat/sets/$setname";
			$setdir = "$cf{imagepath}/$cat/sets/$setname";
		} else {
			$setdir = randset($cat);
			($setname = $setdir) =~ s/^.*\/([^\/]+)$/$1/;
		}
		opendir (D, "$setdir") or perr("Could not open photoset directory $setdir", $filename);
		my @images = sort { $b <=> $a } grep { !/^\./ } readdir D;
		close D;
		mkdir_r("$basepath/$setname/content");
		mkdir_r("$basepath/$setname/thumbs");
		my ($cols, $rows) = matrix(
			$p{pics} || $p{count} || scalar(@images),
			$p{cols} || $p{colcount},
			$p{rows} || $p{rowcount}
		);
		my $cpic = 0;
		$out = qq[<table $cf{tabletag}>\n]; 
		my ($imagehtml, $htmlpath) = readrandtmpl("$cf{datapath}/templates/image", 1);
		foreach (1..$rows) {
			$out .= qq[\t<tr>\n];
			foreach (1..$cols) {
				my $image = $images[$cpic];
				$out .= qq[\t<td $cf{tdtag}>\n].
					qq[\t\t<font $cf{fonttag}>\n\t\t].
					thumbnail($cat, "$setdir/$image",
						"$cf{imagepath}/$cat/thumbs/$setname",
						$imagehtml, $htmlpath, "$basepath/$setname",
						"$baseurl/$setname"
					) . qq[\t</td>\n];
				$cpic++;
			}
			$out .= qq[\t</tr>\n];
		}
		$out .= qq[</table>\n];
	}
	elsif ($symbol eq "images") {
		$out = qq[<table $cf{tabletag}>\n];
		my ($cols, $rows) = matrix(
			$p{pics} || $p{count},
			$p{cols} || $p{colcount},
			$p{rows} || $p{rowcount}
		);
		($cols, $rows) = @cf{"defcols", "defrows"} if !$cols;
		mkdir_r("$cf{imagepath}/$cat/thumbs");
		mkdir_r("$basepath/content");
		mkdir_r("$basepath/thumbs");
		my ($imagehtml, $htmlpath) = readrandtmpl("$cf{datapath}/templates/image", 1);
		foreach (1..$rows) {
			$out .= qq[\t<tr>\n];
			foreach (1..$cols) {
				$out .= qq[\t<td $cf{tdtag}>\n].
					qq[\t\t<font $cf{fonttag}>\n];
				my $imagepath = randimg($cat, "content");
				$out .= qq[\t\t] .
					thumbnail($cat, $imagepath, "$cf{imagepath}/$cat/thumbs",
						$imagehtml, $htmlpath, $basepath, $baseurl);
			}
			$out .= qq[\t</tr>\n];
		}
		$out .= qq[</table>\n];
	}
	elsif ($symbol eq "thumb") {
		mkdir_r("$cf{imagepath}/$cat/thumbs");
		mkdir_r("$basepath/content");
		mkdir_r("$basepath/thumbs");
		my ($imagehtml, $htmlpath) = readrandtmpl("$cf{datapath}/templates/image", 1);
		my $imagepath = randimg($cat, $p{type} || "content");
		$out = thumbnail($cat, $imagepath, "$cf{imagepath}/$cat/thumbs",
			$imagehtml, $htmlpath, $basepath, $baseurl);
	}
	# Thanks to Sean O'Brien
	elsif ($symbol eq "css") {
		if (!$cf{css}) {
			my $query = qq[where scheme="$cf{scheme}"];
			$cf{css} = qq[<style type="text/css">\n] .
					randline("css", $query, "tag") .
					qq[</style>];
		}
		$out = "$cf{css}";
	}
	elsif ($symbol eq "js") {
		if (!$cf{js}) {
			my $query = qq[where scheme="$cf{scheme}"];
			$cf{js} = qq[<script language="Javascript">\n] .
				randline("js", $query, "tag") .
				qq[</script>];
		}
	}
	elsif ($symbol eq "nichelink") {
		$out = qq[<a href="$cat.html">$cat</a>];
	}
	elsif ($symbol eq "avstable") {
		$out = readfile("$cf{datapath}/modules/avstables/$avs.dat");
	}
	elsif (defined $cf{$symbol}) {
		$out = $cf{$symbol};
	}
	else {
		perr("Invalid symbol: $symbol. Refer to the template creation guide included with this scriptset.", $filename);
	}
		
	if ($p{style}) {
		if (grep(/^$p{style}$/, ("u", "b", "i"))) {
			$out = "<$p{style}>$out</$p{style}>";
		}
		elsif ($p{style} eq "uc") {
			$out = uc($out);
		}
		elsif ($p{style} eq "ucf") {
			$out =~ s/^(.)(.*)$/uc($1).lc($2)/e;
		}
		elsif ($p{style} eq "lc") {
			$out = lc($out);
		}
	}

	return $out;
	
	sub	true {
		my $in = shift;
		if ($in =~ /^y(es)?$/i || $in == 1) {
			return 1;
		} else {
			return 0;
		}
	}
	sub	false {
		my $in = shift;
		if (defined $in && ($in =~ /^no?$/i || $in == 0)) {
			return 1;
		} else {
			return 0;
		}
	}
	sub	uniq {
		my ($symbol, $field) = (shift, shift);
		my $ret = join("", map { qq[ and $field != "$_" ] } @{$used{$symbol}});
		return $ret;
	}
	sub	perr {
		my ($err, $fn) = @_;
		err("$err". ($fn ? " (in file: $fn)" : ""));
	}

	sub	randimg {
		my ($cat, $type, $err) = @_;
		my $query = qq[where cat="$cat" and type="$type" and queued=1].
			($used{$type} ? qq[ and (].
			join(" and ", map { qq[image != "$_"] } @{$used{$type}}).
			qq[)] : "");
		my $image = randline("images", $query, "image");
		if (!$image) {
			err("query $query; Not enough images in niche $cat, image type $type; please add more") if $err;
			my $ac = dosql(qq[update ap_images set queued=1 where cat="$cat" and type="$type"]);
			err("No images found for niche $cat, image type $type. Refresh the image ".
				"queue from the main menu to include recently-uploaded pictures, ".
				"or upload to $cf{imagepath}/$cat/$type")
				if !$ac->rows;
			$image = randimg($cat, $type, 1);
		}
		dosql(qq[update ap_images set queued=0 where image="$image" and cat="$cat" and type="$type"]);
		push (@{$used{$type}}, $image);
		$image = "$cf{imagepath}/$cat/$type/$image" if $image !~ /\//;
		err("Image $image (type $type) does not exist, please refresh image queue")
			if !-e $image;
		return $image;
	}
	
	sub	randset {
		my ($cat, $err) = @_;
		my $query = qq[where cat="$cat" and queued=1].
			($used{sets} ? qq[ and (].
			join(" and ", map { qq[setname != "$_"] } @{$used{sets}}).
			qq[)] : "");
		my $set = randline("imagesets", $query, "setname");
		if (!$set) {
			err("Not enough photosets in niche $cat, please add more") if $err;
			my $ac = dosql(qq[update ap_imagesets set queued=1 where cat="$cat"]);
			err("No image sets found for category $cat. Refresh the image queue ".
				"from the main menu to include recently-uploaded pictures, or ".
				"upload to $cf{imagepath}/$cat/sets")
				if !$ac->rows;
			$set = randset($cat, 1);
		}
		dosql(qq[update ap_imagesets set queued=0 where setname="$set" and cat="$cat"]);
		push(@{$used{sets}}, $set);
		$set = "$cf{imagepath}/$cat/sets/$set" if $set !~ /\//;
		err("Set $set does not exist or is not a directory, please refresh image queue")
			if !-d $set;
		return $set;
	}

	sub	matrix {
		# form the shape of a table of images
		my ($pics, $cols, $rows) = @_;
		return ($cols, $rows) if $cols && $rows;

		for (; $pics > (($pics - 5) > 0 ? ($pics - 5) : 0); $pics--) {
			my $starter = sprintf("%.0f", sqrt($pics));
			for (my $n = $starter; $n >= ($pics > 8 ? 3 : 2); $n--) {
				if (int($pics / $n) == ($pics / $n)) {
					($cols, $rows) = ($n, ($pics / $n));
					last;
				}
			}
			last if $cols;
		}
		return ($cols, $rows);
	}

	sub	cpimage {
		my ($imgpath, $basepath, $imgname) = @_;
		if ($cf{usesymlinks} && !$cf{freehost}) {
			symlink ($imgpath, "$basepath/$imgname")
				|| err("Could not create symbolic link to image $imgname, from $imgpath to $basepath/$imgname")
				if (!-e "$basepath/$imgname");
		} else {
			system(qq[cp "$imgpath" "$basepath/$imgname"])
				if (!-e "$basepath/$imgname");
			err("Could not copy image $imgname from $imgpath to $basepath")
				if (!-f "$basepath/$imgname");
		}
	}

	sub	thumbnail {
		# generate a thumbnail image and return it with a link
		# to the full image html
	
		# vars
		my ($cat, $imagepath, $thumbdir, $htmlcode, $htmlpath, $basepath, $baseurl) = @_;
		(my $imagename = $imagepath) =~ s/^.*\/([^\/]+)$/$1/;
		(my $htmlname = $imagename) =~ s/\.(\w+)$/\.$cf{htmlext}/;
		my $thumbx = $p{width} || $p{thumbx} || $cf{defthumbx};
		my $thumby = $p{height} || $p{thumby} || $cf{defthumby};		                                

		# generate thumb in $cf{imagepath}
		mkdir_r($thumbdir);
		my $thumbpath = "$thumbdir/$imagename";
		system("$cf{djpeg} $imagepath | $cf{pnmscale} -xysize $thumby $thumbx | $cf{cjpeg} > $thumbpath")
			if !-e $thumbpath;
		err("Could not create thumbnail image, check original $imagepath is a working ".
			"JPEG graphic and that utility paths are correct (thumb path: $thumbpath)")
			if !-e "$thumbpath" ||
			(stat("$thumbpath"))[7] == 0;
		
		# copy/symlink to the site directory
		cpimage($imagepath, "$basepath/content", $imagename);
		cpimage($thumbpath, "$basepath/thumbs", $imagename);

		# write the new html
		open (F, "> $basepath/content/$htmlname")
			or err("Could not write to HTML file $basepath/content/$htmlname");
		$cf{image} = qq[<img src="http://$baseurl/content/$imagename">];
		print F substapts($htmlcode, $htmlpath, $avs, $sec, $pnum);
		delete $cf{image};
		close F;

		return qq[<a href="http://$baseurl/content/$htmlname">].
			qq[<img src="http://$baseurl/thumbs/$imagename"></a>\n];
	}
}

1;
